/*
 * Win_QrfeDeviceChangeDetector.h
 *
 *  Created on: 25.11.2008
 *      Author: stefan.detter
 */

#ifndef WIN_QRFEDEVICECHANGEDETECTOR_H_
#define WIN_QRFEDEVICECHANGEDETECTOR_H_

#include <QObject>
#include <QAbstractEventDispatcher>
#include <QTimer>
#include <QMainWindow>
#include <QrfeTraceModule>

#ifndef NOMINMAX 
#define NOMINMAX 
#endif

#include <windows.h>
extern "C"
{
#include <hidsdi.h>
}

#ifdef QRFE_DEVICEDETECTOR_DEBUG
#include <QrfeTrace.h>
#endif

class Win_QrfeDeviceChangeDetector: public QWidget
#ifdef QRFE_DEVICEDETECTOR_DEBUG
, QrfeTraceModule
#endif
{
Q_OBJECT
public:
	Win_QrfeDeviceChangeDetector ()	;
~	Win_QrfeDeviceChangeDetector ( );

	virtual bool nativeEvent(const QByteArray &eventType, void *message, long *result);
	virtual bool winEvent ( MSG * msg, long * result );

	bool registerNotification();
	bool unregisterNotification();

signals:
	void usbDeviceAttached(QString devicePath, quint16 vendorID, quint16 productID);
	void usbDeviceRemoved(QString devicePath, quint16 vendorID, quint16 productID);

	void hidDeviceAttached(QString devicePath, quint16 vendorID, quint16 productID);
	void hidDeviceRemoved(QString devicePath, quint16 vendorID, quint16 productID);

    void serialPortAttached ( QString serialPort );
    void serialPortRemoved ( QString serialPort );

private:

	HANDLE m_notifyDeviceInterface_USB;
	HANDLE m_notifyDeviceInterface_HID;
};

#endif /* WIN_QRFEDEVICECHANGEDETECTOR_H_ */
